# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Deque properties of letting operations at both start and end will help.

# Approach
<!-- Describe your approach to solving the problem. -->
Find maximum of each window and add to answer array. 

- Keep an array to store maximum numbers of each window
- Keep a deque to maintain the sliding window         
- - if next number is greater than previous then no need of previous one
- -  maintain window size length 'k'
- - after reaching 'k' numbers start adding to answer array

---

Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

# Complexity
- Time complexity : $$O(n)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity :  $$O(n)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public int[] maxSlidingWindow(int[] nums, int k) {
        int[] a = new int[ nums.length - k + 1];     // to store maximum numbers of each window
        Deque<Integer> dq = new ArrayDeque<>();      // to maintain the sliding window         

        for( int i = 0; i < nums.length; i++){
            while( !dq.isEmpty() && dq.peekLast() < nums[i] ){    // if next number is greater than previous then no need of previous one
                dq.pollLast();
            }
            dq.offerLast( nums[i] );                  
            if( i >= k && nums[i-k] == dq.peekFirst()){    // maintain window size length 'k'
                dq.pollFirst();
            }
            if( i >= k - 1){                        // after reaching 'k' numbers start adding to answer array
                a[i-k+1] = dq.peekFirst();
                //System.out.print( a[i-k+1] + " ");
            }
        }
        return a;
    }
}
```